<?php

namespace UtillzCore\Inc\Src\Admin\Http\Endpoints;

use \UtillzCore\Inc\Src\Request\Request;
use \UtillzCore\Inc\Src\Listing\Listing;

if ( ! defined('ABSPATH') ) {
	exit;
}

class Endpoint_Load_More_Reviews extends Endpoint {

	public $action = 'utillz-action-load-more-reviews';

    public function action() {

		$request = Request::instance();

		if( $request->is_empty('listing_id') || $request->is_empty('onpage') ) {
			return;
		}

		global $ulz_listing;
		$ulz_listing = new Listing( $request->get('listing_id') );

		if( ! $ulz_listing->id ) {
			return;
		}

		$comments_per_page = max( 1, $ulz_listing->type->get('ulz_reviews_per_page') );

		wp_send_json([
			'success' => true,
			'max_num_pages' => ceil( $ulz_listing->reviews->count / $comments_per_page ),
			'html' => Ucore()->get_template('single/reviews/comments/list')
		]);

	}

}
